#=============================================================================================
# The main functions for generating the results of the SPD module
# Dependencies:
# "SPD_util.R"  sourced by describe.selected.genes
# "source - utils.r" sourced by store.SGD.results
#=============================================================================================

# This is the main function of the SGD.module. It is a wrapper around describe.selected.gene (plot rendering) and store.SGD.results (plot storing)
# functions it returns a list of lists (tree) containing the uri to the plots. The structure of this list of lists encodes the html hierarchy

run.SPD.module <- function(dat,
                           prb.annots,
                           smp.annots,
                           #color.annots,
                           color.cat.annots,
                           probe.ids.to.describe,
                           describe.probes.by = NULL,
                           stratify.probe.desription.by = NULL,
                           trend.by = NULL,
                           order.trend.by = NULL,
                           stratify.trend.by = NULL,
                           generate.interactnet.plot = FALSE,
                           interactnet.adjustfor = NULL,
                           file.extension = c("png","pdf","tiff","jpg","bmp"),
                           path.to.SPD.results){
  
  source("./R_source/source - SPD_util.R")
  
  SPD <- describe.selected.probes(dat = dat,
                                  prb.annots = prb.annots,
                                  smp.annots = smp.annots ,
                                  probe.ids.to.describe = probe.ids.to.describe,
                                  describe.probes.by = describe.probes.by,
                                  stratify.probe.desription.by = stratify.probe.desription.by,
                                  trend.by = trend.by,
                                  order.trend.by = order.trend.by,
                                  stratify.trend.by = stratify.trend.by,
                                  generate.interactnet.plot = generate.interactnet.plot,
                                  interactnet.adjustfor = interactnet.adjustfor)
  
  # Modify colors
  #--------------
  plots.to.modify.col <- c("cor.plots","PCA.biplots","parcor.plots")
  for(plt.type  in plots.to.modify.col){
    if(is.null(SPD[[plt.type]]))
      next
    for(annot.i in names(SPD[[plt.type]])){
      for(plt in names(SPD[[plt.type]][[annot.i]])){
        if(!"SPD" %in% class(SPD[[plt.type]][[annot.i]][[plt]]))
          stop("SPD[[plt.type]][[annot.i]][[plt]] is not a SPD plot")
        p <- SPD[[plt.type]][[annot.i]][[plt]]
        tmp <- try(SPD.plot.chnage.color(p=p,colors = unname(color.cat.annots[[annot.i]][SPD.plot.get.color.levels(p)])))
        if(all(class(tmp) != "try-error"))
          SPD[[plt.type]][[annot.i]][[plt]] <- tmp
      }
        
    }
    
  }
  
  
  

  file.extension <- unique(c("png",file.extension))
  for(flx in file.extension){
    tmp <- store.SPD.results(SPD = SPD,file.extension = flx, path.to.SPD.results = path.to.SPD.results)
    if(flx == "png")
      SPD.dir <- tmp
  }
  
  
  return(SPD.dir)  
}




describe.selected.probes <- function(dat,
                                     prb.annots,
                                     smp.annots,
                                     probe.ids.to.describe,
                                     describe.probes.by = NULL,
                                     stratify.probe.desription.by = NULL, # <---- This is not currently being used
                                     trend.by = NULL,
                                     order.trend.by = NULL,
                                     stratify.trend.by = NULL,
                                     generate.interactnet.plot=FALSE,
                                     interactnet.adjustfor = NULL){
  
  
  
  
  # hard-coded annotation var names
  #--------------------------------
  var.probe.names <- "Probe.Label"
  var.probe.types <- "Analyte.Type"
  
  # validate the input
  #-------------------
  if(!var.probe.names %in% colnames(prb.annots))
    stop(paste(var.probe.names, "needs to be in columns of prb.annots"))
  
  if(!var.probe.types %in% colnames(prb.annots))
    sotp(paste(var.probe.types,"needs to be in columns of prb.annots"))
  
  if(!is.character(probe.ids.to.describe))
    stop("probe.ids.to.describe needs to be character")
  
  if(any(!probe.ids.to.describe %in% colnames(dat)))
    stop("probe.ids.to.describe needs to be in colnames of normalized")
  
  if(!is.data.frame(smp.annots))
    stop("smp.annots need to be a data.frame")
  
  if(sum(!complete.cases(smp.annots))!= 0)
    warning("There are missing annotations: samples with missing annotation will be disregarded")
  
  if(!all.equal(rownames(smp.annots),rownames(dat)))
    stop("rownames of the smp.annots should match those of the dat")
 
  
  if(is.null(describe.probes.by))
    describe.probes.by <- "no_annotation"
  
  if(is.null(stratify.trend.by))
    stratify.trend.by <- "no_annotation"
  
  if(is.null(interactnet.adjustfor))
    interactnet.adjustfor <- "no_annotation"
  
  # probe annotation variables for convenience
  #-------------------------------------------
  probe.names <- prb.annots[,var.probe.names,drop=F]
  probe.types <- prb.annots[,var.probe.types,drop=F]
  
  
  # Trend plot options validation
  generate.trend.plot <- FALSE
  if(!is.null(trend.by) & !is.null(order.trend.by)){
    if(!trend.by %in% colnames(smp.annots))
      stop("trend.by needs to be in the colnames of smp.annots")
    if(!order.trend.by %in% colnames(smp.annots))
      stop("order.trend.by needs to be in the colnames of smp.annots")
    generate.trend.plot <- TRUE
  }
  
  # ---->validation of stratify <------
  
  # Determine description-type
  description.type <- "single.probe"
  if(length(probe.ids.to.describe)>1)
    description.type <- "multi.probe"
  
  
  # Initiate plot lists
  #--------------------
  univar.plots <- cor.plots <- PCA.biplots <- parcor.plots <- list()
  length(univar.plots) <- length(cor.plots) <- length(PCA.biplots) <- length(parcor.plots) <- length(describe.probes.by)
  names(univar.plots) <- names(cor.plots) <- names(PCA.biplots) <- names(parcor.plots)  <- describe.probes.by
  
  interactNet.plots <- list()
  length(interactNet.plots) <- length(interactnet.adjustfor)# currently 1
  names(interactNet.plots) <- interactnet.adjustfor
  
  trend.plots <- list()
  length(trend.plots) <- length(stratify.trend.by) # currently 1
  names(trend.plots) <- stratify.trend.by
  
  #single or multi probe shared analysis
  #------------------------------------
  
  for(annot.i in describe.probes.by){
    #print(annot.i)
    
    #univariate plot: violin or scatter plot 1 per annot
    #----------------------------------------------------
    for(probe.i in probe.ids.to.describe){
      if(annot.i %in% colnames(smp.annots)){
        univar.plot.fun <- violin.by.probe
        if(is.numeric(smp.annots[[annot.i]]))
          univar.plot.fun <- scatter.by.probe
        
        # update status report
        cat(paste("document.write('<p>Creating univariate plot by",annot.i,"for probe",probe.i,"</p>');"), file=paste(path.inc,"//status.js",sep=""),append=TRUE)
        
        univar.plots[[annot.i]][[probe.i]] <- univar.plot.fun(dat = dat,
                                                              probe.id = probe.i,
                                                              probe.name = as.character(probe.names[probe.i,1]) ,
                                                              smp.annot =smp.annots[,annot.i,drop=F])
      }else{
        warning("No valid sample annotation is provide. Univaraite plots are not generated")
      }

    }
    
    
    # update status report
    cat(paste("document.write('<p>Creating corrlation plots",ifelse(annot.i %in% colnames(smp.annots),paste("stratified by",annot.i),""),"</p>');"), file=paste(path.inc,"//status.js",sep=""),append=TRUE)
    cor.plots[[annot.i]][["select_probes_corplot"]] <- corplot(dat = dat,
                                                               probe.ids = probe.ids.to.describe,
                                                               probe.names = prb.annots[,var.probe.names,drop=F],
                                                               probe.types = prb.annots[,var.probe.types,drop=F],
                                                               smp.annot = if(annot.i %in% colnames(smp.annots)){smp.annots[,annot.i,drop=F]}else{NULL} )
  }
  
  # multi-probe analysis
  #--------------------
  if(description.type == "multi.probe"){
    
    for(annot.i in describe.probes.by){
      
      
      #PCA.biplots
      #-----------
      if(length(probe.ids.to.describe)>4 & nrow(dat)>2){
        
        
        # update status report
        cat(paste("document.write('<p>Creating PCA biplots",ifelse(annot.i %in% colnames(smp.annots),paste("labeled by",annot.i),""),"</p>');"), file=paste(path.inc,"//status.js",sep=""),append=TRUE)
        
        PCA.biplots[[annot.i]] <- pca.biplot(dat = dat,
                                             probe.ids = probe.ids.to.describe,
                                             probe.names = probe.names,
                                             probe.types = probe.types,
                                             smp.annot = if(annot.i %in% colnames(smp.annots)){smp.annots[,annot.i,drop=F]}else{NULL})
        
      }else{
        msg <- "PCA biplot is not generated as "
        if(nrow(dat)<=3)
          msg <- paste(msg,"the number of samples < 3,",sep="")
        if(length(probe.ids.to.describe)<=4)
          msg <- paste(msg,"the number of probes < 5,",sep="")
        warning(paste(unlist(strsplit(x = msg,split = ",")),collapse = ", and "))
      }
      
      
      #parcor.plots
      #--------------
      if(length(unique(if(annot.i %in% colnames(smp.annots)){smp.annots[,annot.i]}else{NULL})) >1){
        # update status report
        cat(paste("document.write('<p>Creating parallel coordinate plots for",annot.i,"</p>');"), file=paste(path.inc,"//status.js",sep=""),append=TRUE)
        parcor.plots[[annot.i]][["select_probes_parcorplot"]] <- parcor.plot(dat = dat,
                                                                             probe.ids = probe.ids.to.describe,
                                                                             probe.names = probe.names,
                                                                             probe.types = probe.types,
                                                                             smp.annot = smp.annots[,annot.i,drop=F],
                                                                             scale.by.probe = T)
      }else{
        if(annot.i %in% colnames(smp.annots))
          warning(paste(annot.i,"less than 2 levels when casted as a categorical variable. Therefore, parallel coordinate plot is not generated"))
        else
          warning("No sample annotation is provided.Therefore, parallel coordinate plot is not generated")
      }
      
    }
    
    # interactNet
    #------------
    if(generate.interactnet.plot){

      # update status report
      cat(paste("document.write('<p>Creating interaction network plot",ifelse(interactnet.adjustfor %in% colnames(smp.annots),paste("adjusted for",interactnet.adjustfor),""), "</p>');"), file=paste(path.inc,"//status.js",sep=""),append=TRUE)
      
      tmp <-  interactnet.plot(dat = dat,
                               probe.ids = probe.ids.to.describe,
                               probe.names = probe.names,
                               probe.types = probe.types,
                               smp.annot = smp.annots,
                               adj.for.var = interactnet.adjustfor)
      if(is.null(tmp)){
        num.adj.terms <- 0
        if(interactnet.adjustfor!="no_annotation")
          num.adj.terms <- ifelse(is.numeric(smp.annots[,interactnet.adjustfor]),1,nlevels(smp.annots[,interactnet.adjustfor])-1 )
        
        num.terms <- length(probe.ids.to.describe[-1]) + 1 + num.adj.terms
        # dof <- nrow(dat) - num.terms
        wtmp <- paste("InteractNet will not be generated. At least", num.terms + 1, "samples are needed to estimate InteractNet as specificed. Number of probes + adjustment term needs to be smaller than",num.terms,sep=" ")
        warning(wtmp)
        cat(paste("document.write('<p>",wtmp,"</p>');"), file=paste(path.inc,"//status.js",sep=""),append=TRUE)
      }
      
      
      interactNet.plots[[interactnet.adjustfor]][["select_probes_interactnetplot"]] <- tmp
      
    }
    }
   
  
  # Trend analysis
  #---------------
  if(generate.trend.plot){
    
    #print(probe.i)
    
    # update status report
    cat(paste("document.write('<p>Creating trend plots","</p>');"), file=paste(path.inc,"//status.js",sep=""),append=TRUE)
    
    trend.plots[[stratify.trend.by]][["select_probes_trendplot"]] <- trend.plot(dat = dat,
                                                                                probe.ids = probe.ids.to.describe,
                                                                                probe.names = probe.names,
                                                                                probe.types = probe.types,
                                                                                smp.annot = smp.annots,
                                                                                var.to.trend.by = trend.by,
                                                                                var.to.order.obs.by = order.trend.by,
                                                                                var.to.stratify.by = stratify.trend.by,
                                                                                adj.to.tmin = T,
                                                                                xlab = order.trend.by)
    
  }
  

  
  
  # build the Select probes Descriptives object
  #-------------------------------------------
  SPD <- list(univar.plots = univar.plots,
              cor.plots = cor.plots,
              PCA.biplots = PCA.biplots,
              parcor.plots = parcor.plots,
              interactNet.plots = interactNet.plots,
              trend.plots = trend.plots)
  
  return(SPD)
}


# # This function handles storing the Select probe Descriptives
# store.SPD.results <- function(SPD, file.extension = c("png","pdf","tiff","jpg","bmp"),path.results,dir.name = "SPD"){
#   file.extension <- match.arg(file.extension)
#   source("R_source/source - utils.r")
#   
#   plt.directories <- SPD # initiate plt.directories
#   
#   SPD.path <- paste(path.results,"/",dir.name,"/",sep="")
#   dir.create(SPD.path,showWarnings = F)
#   
#   # 1- By plot type (e.g. PCA, univariate etc.)
#   #--------------------------------------------
#   for(plot.type.i in names(SPD)){
#     #cat(plot.type.i," ")
#     plttype.level.path.i <- correct.filename(file.path(SPD.path,plot.type.i))
#     dir.create(plttype.level.path.i,showWarnings = F)
#     
#     # 2- By annotation variable (e.g. Subtype, BMI etc.)
#     #---------------------------------------------------
#     for(smp.annot.i in names(SPD[[plot.type.i]])){
#       #cat(smp.annot.i,"\n")
#       annot.level.path.i <- correct.filename(file.path(plttype.level.path.i, smp.annot.i))
#       
#       if(all(class(SPD[[plot.type.i]][[smp.annot.i]]) == "list")){
#         dir.create(annot.level.path.i,showWarnings = F)
#         
#         #3- By the number of plots (e.g. PC1,PC2,PC3 or 5 plots for 5 selected probes)
#         #--------------------------------------------------------
#         for(plt.i in names(SPD[[plot.type.i]][[smp.annot.i]])){
#           
#           if(!is.null(SPD[[plot.type.i]][[smp.annot.i]][[plt.i]])){
#             filename <- correct.filename(file.path(annot.level.path.i,plt.i))
#             print(filename)
#             #           tmp <- drawplot(filename=filename)
#             #           SPD[[plot.type.i]][[smp.annot.i]][[plt.i]]
#             #           dev.off()
#             if("ggplot" %in% class(SPD[[plot.type.i]][[smp.annot.i]][[plt.i]])){
#               ggsave(filename = paste(filename,file.extension,sep="."), plot = SPD[[plot.type.i]][[smp.annot.i]][[plt.i]],width = 12,height = 8,scale = 1,dpi = 300,units = "in")
#             }else{
#               drawplot(filename = filename,type = file.extension,width = 2,height = 2)
#               print(SPD[[plot.type.i]][[smp.annot.i]][[plt.i]])
#               dev.off()
#             }
#             #store the directory for the plot
#             plt.directories[[plot.type.i]][[smp.annot.i]][[plt.i]] <- paste(filename,file.extension,sep=".")
#           }
#         }
#       }else{
#         if(!is.null(SPD[[plot.type.i]][[smp.annot.i]])){
#           filename <- annot.level.path.i
#           print(filename)
#           #         tmp <- drawplot(filename=filename)
#           #         SPD[[plot.type.i]][[smp.annot.i]]
#           #         dev.off()
#           if("ggplot" %in% class(SPD[[plot.type.i]][[smp.annot.i]])){
#             ggsave(filename = paste(filename,file.extension,sep="."), plot = SPD[[plot.type.i]][[smp.annot.i]],,width = 12,height = 8,scale = 1,dpi = 300,units = "in" )
#           }else{
#             drawplot(filename = filename,type = file.extension,width = 2,height = 2)
#             print(SPD[[plot.type.i]][[smp.annot.i]])
#             dev.off()
#           }
#           plt.directories[[plot.type.i]][[smp.annot.i]] <- paste(filename,file.extension,sep=".")
#         }
#         
#       }
#     }
#   }
#   return(plt.directories)
# }


# This function handles storing the Select probe Descriptives
store.SPD.results <- function(SPD, file.extension = c("png","pdf","tiff","jpg","bmp"),path.to.SPD.results){
  file.extension <- gsub(pattern = "\\.",replacement = "",x = file.extension)
  file.extension <- match.arg(file.extension)
  source("R_source/source - utils.r")
  
  plt.directories <- SPD # initiate plt.directories
  
  if(! file.exists(path.to.SPD.results))
    dir.create(path.to.SPD.results,showWarnings = F)
  
  # 1- By plot type (e.g. PCA, univariate etc.)
  #--------------------------------------------
  for(plot.type.i in names(SPD)){
    #cat(plot.type.i," ")
    plttype.level.path.i <- correct.filename(file.path(path.to.SPD.results,plot.type.i))
    dir.create(plttype.level.path.i,showWarnings = F)
    
    # 2- By annotation variable (e.g. Subtype, BMI etc.)
    #---------------------------------------------------
    for(smp.annot.i in names(SPD[[plot.type.i]])){
      #cat(smp.annot.i,"\n")
      annot.level.path.i <- correct.filename(file.path(plttype.level.path.i, smp.annot.i))
      
      if(all(class(SPD[[plot.type.i]][[smp.annot.i]]) == "list")){
        dir.create(annot.level.path.i,showWarnings = F)
        
        #3- By the number of plots (e.g. PC1,PC2,PC3 or 5 plots for 5 selected probes)
        #--------------------------------------------------------
        for(plt.i in names(SPD[[plot.type.i]][[smp.annot.i]])){
          
          if(!is.null(SPD[[plot.type.i]][[smp.annot.i]][[plt.i]])){
            filename <- correct.filename(file.path(annot.level.path.i,plt.i))
            print(filename)
            #           tmp <- drawplot(filename=filename)
            #           SPD[[plot.type.i]][[smp.annot.i]][[plt.i]]
            #           dev.off()
            if("ggplot" %in% class(SPD[[plot.type.i]][[smp.annot.i]][[plt.i]])){
              ggsave(filename = paste(filename,file.extension,sep="."), plot = SPD[[plot.type.i]][[smp.annot.i]][[plt.i]],width = 12,height = 8,scale = 1,dpi = 300,units = "in")
            }else{
              drawplot(filename = filename,type = file.extension,width = 2,height = 2)
              print(SPD[[plot.type.i]][[smp.annot.i]][[plt.i]])
              dev.off()
            }
            #store the directory for the plot
            plt.directories[[plot.type.i]][[smp.annot.i]][[plt.i]] <- paste(filename,file.extension,sep=".")
          }
        }
      }else{
        if(!is.null(SPD[[plot.type.i]][[smp.annot.i]])){
          filename <- annot.level.path.i
          print(filename)
          #         tmp <- drawplot(filename=filename)
          #         SPD[[plot.type.i]][[smp.annot.i]]
          #         dev.off()
          if("ggplot" %in% class(SPD[[plot.type.i]][[smp.annot.i]])){
            ggsave(filename = paste(filename,file.extension,sep="."), plot = SPD[[plot.type.i]][[smp.annot.i]],width = 12,height = 8,scale = 1,dpi = 300,units = "in" )
          }else{
            drawplot(filename = filename,type = file.extension,width = 2,height = 2)
            print(SPD[[plot.type.i]][[smp.annot.i]])
            dev.off()
          }
          plt.directories[[plot.type.i]][[smp.annot.i]] <- paste(filename,file.extension,sep=".")
        }
        
      }
    }
  }
  return(plt.directories)
}




# This function accesses the argument file and validates its SPD.annot.args contents for SPD run
# @ dat: the data.frame containing the data to be analyzed by SPD
# @ smp.annots: sample annotation file
# @ SPD.annot.args: a character verctor contraining all SPD related argumnets (i.e. colnames of annotations to be used in SPD run)
# @ SPD.prb.names.arg: names of the variable contraining the names of the probes to be described within the argument file
# value:
# warnings to be appended to the list of warnings to be displayed.

validate.SPD.arguments <- function(dat,
                                   smp.annots,
                                   SPD.annot.args=c("SPDarg.describe.probes.by",
                                                    "SPDarg.interactnet.adjustfor",
                                                    #"SPDarg.interactnet.stratifyby",
                                                    "SPDarg.order.expression.trend.by",
                                                    "SPDarg.stratify.expression.trend.by",
                                                    "SPDarg.trend.expression.by"),
                                   SPD.prb.names.arg = "SPDarg.probe.names.to.describe"){
  
  var.to.message <- c(SPDarg.describe.probes.by = "to describe probe(s) by",
                      SPDarg.interactnet.adjustfor = "to adjust interactnet for",
                      #SPDarg.interactnet.stratifyby = "to staratify interactnet by",
                      SPDarg.order.expression.trend.by = "to order expression trend by",
                      SPDarg.probe.names.to.describe = "as probe names",
                      SPDarg.stratify.expression.trend.by = "to stratify expression trend by",
                      SPDarg.trend.expression.by = "to trend expression by")
  wtmp <- NULL
  
  tmp.env <- new.env()
  source("./arguments.r",local = tmp.env)
  
  
  for(arg.i in SPD.annot.args){
    
    tmp.annot.names <- get(arg.i,envir = tmp.env)
    
    # ignore variable if it is NULL or NA
    if(length(tmp.annot.names)<2){
      if(is.null(tmp.annot.names))
        next
      if(is.na(tmp.annot.names))
        next
    }
    
    # for non-NULL non-NA validate the argument
    #------------------------------------------
    tmp.annot.renames <- reconcile.variables.with.annot(annot = smp.annots,
                                                        variables = tmp.annot.names,
                                                        variabletypes=NULL,
                                                        referencelevels=NULL)$variables
    
    assign(arg.i,value = tmp.annot.renames,envir = globalenv())
    
    if(length(get(arg.i))==0){
      wtmp0 <- paste(tmp.annot.names,"is not a valid annotation to",var.to.message[arg.i],"and is removed from SPD analysis\n")
      warning(wtmp0)
      wtmp <- paste(wtmp,"Warning:",wtmp0)
      
      assign(arg.i,value = NULL,envir = globalenv())
    }
    
    # Generate warning when annotation contains NA
    else{
      for(annot.name.i in get(arg.i)){
        if(sum(is.na(smp.annots[annot.name.i]))>0){
          wtmp0 <- paste(annot.name.i," contains NA for some samples! These samples are ignored in SPD when analyzing relative to",annot.name.i,"\n")
          warning(wtmp0)
          wtmp <- paste(wtmp,"Warning:",wtmp0)
        }
      }
    }
    
  }
  
  # Evaluate probe.names to keep only those probes that are not filtered out for whatever reason
  probe.names.to.describe <- get(SPD.prb.names.arg,envir = tmp.env)
  
  if(any(!probe.names.to.describe %in% colnames(dat))){
    wtmp <- paste(paste(probe.names.to.describe[!probe.names.to.describe %in% colnames(dat)],collapse = ","),"removed in previous analysis steps and will not be included in SPD analysis")
    warning(wtmp)
    wtmp <- paste(wtmp,"Warning:",wtmp,"\n")
    probe.names.to.describe <- probe.names.to.describe[probe.names.to.describe %in% colnames(dat)] 
    assign(SPD.prb.names.arg,value = probe.names.to.describe,envir = globalenv())
  }
  
  
  return(wtmp)
  
}

